/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.BlockColumnFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.NetherForestVegetationFeature;
import net.minecraft.world.level.levelgen.feature.OreFeature;
import net.minecraft.world.level.levelgen.feature.RandomPatchFeature;
import net.minecraft.world.level.levelgen.feature.RandomSelectorFeature;
import net.minecraft.world.level.levelgen.feature.SimpleBlockFeature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.StructureWorldNBT;
import org.betterx.bclib.api.v2.poi.BCLPoiType;
import org.betterx.bclib.api.v3.levelgen.features.BCLConfigureFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLInlinePlacedBuilder;
import org.betterx.bclib.api.v3.levelgen.features.config.PillarFeatureConfig;
import org.betterx.bclib.api.v3.levelgen.features.config.PlaceFacingBlockConfig;
import org.betterx.bclib.api.v3.levelgen.features.config.SequenceFeatureConfig;
import org.betterx.bclib.api.v3.levelgen.features.config.TemplateFeatureConfig;
import org.betterx.bclib.api.v3.levelgen.features.features.PillarFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.PlaceBlockFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.SequenceFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.TemplateFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.util.FullReferenceHolder;
import org.betterx.bclib.util.Triple;
import org.jetbrains.annotations.NotNull;

public abstract class BCLFeatureBuilder<F extends Feature<FC>, FC extends FeatureConfiguration> {
    static ConcurrentLinkedQueue<BCLConfigureFeature.Unregistered<?, ?>> UNBOUND_FEATURES = new ConcurrentLinkedQueue();
    protected final ResourceLocation featureID;
    private final F feature;

    public static <F extends Feature<FC>, FC extends FeatureConfiguration> WithConfiguration<F, FC> start(ResourceLocation featureID, F feature) {
        return new WithConfiguration(featureID, feature);
    }

    public static ForSimpleBlock start(ResourceLocation featureID, Block block) {
        return BCLFeatureBuilder.start(featureID, (BlockStateProvider)BlockStateProvider.m_191382_((Block)block));
    }

    public static ForSimpleBlock start(ResourceLocation featureID, BlockState state) {
        return BCLFeatureBuilder.start(featureID, (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state));
    }

    public static ForSimpleBlock start(ResourceLocation featureID, BlockStateProvider provider) {
        return new ForSimpleBlock(featureID, (SimpleBlockFeature)Feature.f_65741_, provider);
    }

    public static WeightedBlock startWeighted(ResourceLocation featureID) {
        return new WeightedBlock(featureID, (SimpleBlockFeature)Feature.f_65741_);
    }

    public static WeightedBlockPatch startWeightedRandomPatch(ResourceLocation featureID) {
        return new WeightedBlockPatch(featureID, (RandomPatchFeature)Feature.f_65763_);
    }

    public static WeightedBlockPatch startBonemealPatch(ResourceLocation featureID) {
        return BCLFeatureBuilder.startWeightedRandomPatch(featureID).likeDefaultBonemeal();
    }

    public static RandomPatch startRandomPatch(ResourceLocation featureID, Holder<PlacedFeature> featureToPlace) {
        return new RandomPatch(featureID, (RandomPatchFeature)Feature.f_65763_, featureToPlace);
    }

    public static AsRandomSelect startRandomSelect(ResourceLocation featureID) {
        return new AsRandomSelect(featureID, (RandomSelectorFeature)Feature.f_65754_);
    }

    public static AsMultiPlaceRandomSelect startRandomSelect(ResourceLocation featureID, AsMultiPlaceRandomSelect.Placer placementModFunction) {
        return new AsMultiPlaceRandomSelect(featureID, (RandomSelectorFeature)Feature.f_65754_, placementModFunction);
    }

    public static NetherForrestVegetation startNetherVegetation(ResourceLocation featureID) {
        return new NetherForrestVegetation(featureID, (NetherForestVegetationFeature)Feature.f_65744_);
    }

    public static NetherForrestVegetation startBonemealNetherVegetation(ResourceLocation featureID) {
        return new NetherForrestVegetation(featureID, (NetherForestVegetationFeature)Feature.f_65744_).spreadHeight(1).spreadWidth(3);
    }

    public static WithTemplates startWithTemplates(ResourceLocation featureID) {
        return new WithTemplates(featureID, (TemplateFeature)BCLFeature.TEMPLATE);
    }

    public static AsBlockColumn<BlockColumnFeature> startColumn(ResourceLocation featureID) {
        return new AsBlockColumn<BlockColumnFeature>(featureID, (BlockColumnFeature)Feature.f_190875_);
    }

    public static AsPillar startPillar(ResourceLocation featureID, PillarFeatureConfig.KnownTransformers transformer) {
        return new AsPillar(featureID, (PillarFeature)BCLFeature.PILLAR, transformer);
    }

    public static AsSequence startSequence(ResourceLocation featureID) {
        return new AsSequence(featureID, (SequenceFeature)BCLFeature.SEQUENCE);
    }

    public static AsOre startOre(ResourceLocation featureID) {
        return new AsOre(featureID, (OreFeature)Feature.f_65731_);
    }

    public static FacingBlock startFacing(ResourceLocation featureID) {
        return new FacingBlock(featureID, (PlaceBlockFeature)BCLFeature.PLACE_BLOCK);
    }

    private BCLFeatureBuilder(ResourceLocation featureID, F feature) {
        this.featureID = featureID;
        this.feature = feature;
    }

    public static <F extends Feature<FC>, FC extends FeatureConfiguration> Holder<ConfiguredFeature<FC, F>> register(BootstapContext<ConfiguredFeature<?, ?>> ctx, ResourceLocation id, ConfiguredFeature<FC, F> cFeature) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)id);
        return (Holder)ctx.m_255272_(key, cFeature);
    }

    public abstract FC createConfiguration();

    protected BCLConfigureFeature<F, FC> buildAndCreateHolder(HolderBuilder<F, FC> holderBuilder) {
        return this.buildAndCreateHolder((featureID, holder) -> new BCLConfigureFeature(featureID, holder, true), holderBuilder);
    }

    protected <B extends BCLConfigureFeature<F, FC>> B buildAndCreateHolder(FeatureBuilder<F, FC, B> featureBuilder, HolderBuilder<F, FC> holderBuilder) {
        FC config = this.createConfiguration();
        if (config == null) {
            throw new IllegalStateException("Feature configuration for " + this.featureID + " can not be null!");
        }
        ConfiguredFeature cFeature = new ConfiguredFeature(this.feature, config);
        Holder<ConfiguredFeature<FC, F>> holder = holderBuilder.apply(this.featureID, cFeature);
        return featureBuilder.create(this.featureID, holder);
    }

    public BCLConfigureFeature<F, FC> buildAndRegister(BootstapContext<ConfiguredFeature<?, ?>> bootstrapCtx) {
        return this.buildAndCreateHolder((featureID, cFeature) -> BCLFeatureBuilder.register(bootstrapCtx, featureID, cFeature));
    }

    public BCLConfigureFeature<F, FC> buildInline() {
        return this.buildAndCreateHolder((featureID, cFeature) -> Holder.m_205709_((Object)cFeature));
    }

    public BCLConfigureFeature.Unregistered<F, FC> build() {
        BCLConfigureFeature.Unregistered res = this.buildAndCreateHolder((featureID, holder) -> new BCLConfigureFeature.Unregistered(featureID, holder), (featureID, cFeature) -> FullReferenceHolder.create(Registries.f_256911_, featureID, cFeature));
        UNBOUND_FEATURES.add(res);
        return res;
    }

    public static void registerUnbound(BootstapContext<ConfiguredFeature<?, ?>> bootstapContext) {
        UNBOUND_FEATURES.forEach((Consumer<BCLConfigureFeature.Unregistered<?, ?>>)((Consumer<BCLConfigureFeature.Unregistered>)u -> u.register(bootstapContext)));
        UNBOUND_FEATURES.clear();
    }

    public BCLInlinePlacedBuilder<F, FC> inlinePlace() {
        BCLConfigureFeature<F, FC> f = this.buildInline();
        return BCLInlinePlacedBuilder.place(f);
    }

    public Holder<PlacedFeature> inlinePlace(BCLInlinePlacedBuilder<F, FC> placer) {
        BCLConfigureFeature<F, FC> f = this.buildInline();
        return placer.build(f).getPlacedFeature();
    }

    public static class WithConfiguration<F extends Feature<FC>, FC extends FeatureConfiguration>
    extends BCLFeatureBuilder<F, FC> {
        private FC configuration;

        private WithConfiguration(@NotNull ResourceLocation featureID, @NotNull F feature) {
            super(featureID, feature);
        }

        public WithConfiguration<F, FC> configuration(FC config) {
            this.configuration = config;
            return this;
        }

        @Override
        public FC createConfiguration() {
            if (this.configuration == null) {
                if (NoneFeatureConfiguration.f_67737_ != null) {
                    return (FC)NoneFeatureConfiguration.f_67737_;
                }
                return (FC)NoneFeatureConfiguration.f_67816_;
            }
            return this.configuration;
        }
    }

    public static class ForSimpleBlock
    extends BCLFeatureBuilder<SimpleBlockFeature, SimpleBlockConfiguration> {
        private final BlockStateProvider provider;

        private ForSimpleBlock(@NotNull ResourceLocation featureID, @NotNull SimpleBlockFeature feature, @NotNull BlockStateProvider provider) {
            super(featureID, feature);
            this.provider = provider;
        }

        @Override
        public SimpleBlockConfiguration createConfiguration() {
            return new SimpleBlockConfiguration(this.provider);
        }
    }

    public static class WeightedBlock
    extends WeightedBaseBlock<SimpleBlockFeature, SimpleBlockConfiguration, WeightedBlock> {
        private WeightedBlock(@NotNull ResourceLocation featureID, @NotNull SimpleBlockFeature feature) {
            super(featureID, feature);
        }

        @Override
        public SimpleBlockConfiguration createConfiguration() {
            return new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(this.stateBuilder.m_146270_()));
        }
    }

    public static class WeightedBlockPatch
    extends WeightedBaseBlock<RandomPatchFeature, RandomPatchConfiguration, WeightedBlockPatch> {
        private BlockPredicate groundType = null;
        private boolean isEmpty = true;
        private int tries = 96;
        private int xzSpread = 7;
        private int ySpread = 3;

        protected WeightedBlockPatch(@NotNull ResourceLocation featureID, @NotNull RandomPatchFeature feature) {
            super(featureID, feature);
        }

        public WeightedBlockPatch isEmpty() {
            return this.isEmpty(true);
        }

        public WeightedBlockPatch isEmpty(boolean value) {
            this.isEmpty = value;
            return this;
        }

        public WeightedBlockPatch isOn(BlockPredicate predicate) {
            this.groundType = predicate;
            return this;
        }

        public WeightedBlockPatch isEmptyAndOn(BlockPredicate predicate) {
            return this.isEmpty().isOn(predicate);
        }

        public WeightedBlockPatch likeDefaultNetherVegetation() {
            return this.likeDefaultNetherVegetation(8, 4);
        }

        public WeightedBlockPatch likeDefaultNetherVegetation(int xzSpread, int ySpread) {
            this.xzSpread = xzSpread;
            this.ySpread = ySpread;
            this.tries = xzSpread * xzSpread;
            return this;
        }

        public WeightedBlockPatch likeDefaultBonemeal() {
            return this.tries(9).spreadXZ(3).spreadY(1);
        }

        public WeightedBlockPatch tries(int v) {
            this.tries = v;
            return this;
        }

        public WeightedBlockPatch spreadXZ(int v) {
            this.xzSpread = v;
            return this;
        }

        public WeightedBlockPatch spreadY(int v) {
            this.ySpread = v;
            return this;
        }

        @Override
        public RandomPatchConfiguration createConfiguration() {
            BCLInlinePlacedBuilder blockFeature = BCLFeatureBuilder.start(new ResourceLocation(this.featureID.m_135827_(), "tmp_" + this.featureID.m_135815_()), Feature.f_65741_).configuration(new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(this.stateBuilder.m_146270_()))).inlinePlace();
            if (this.isEmpty) {
                blockFeature.isEmpty();
            }
            if (this.groundType != null) {
                blockFeature.isOn(this.groundType);
            }
            return new RandomPatchConfiguration(this.tries, this.xzSpread, this.ySpread, blockFeature.build().getPlacedFeature());
        }
    }

    public static class RandomPatch
    extends BCLFeatureBuilder<RandomPatchFeature, RandomPatchConfiguration> {
        private final Holder<PlacedFeature> featureToPlace;
        private int tries = 96;
        private int xzSpread = 7;
        private int ySpread = 3;

        private RandomPatch(@NotNull ResourceLocation featureID, @NotNull RandomPatchFeature feature, @NotNull Holder<PlacedFeature> featureToPlace) {
            super(featureID, feature);
            this.featureToPlace = featureToPlace;
        }

        public RandomPatch likeDefaultNetherVegetation() {
            return this.likeDefaultNetherVegetation(8, 4);
        }

        public RandomPatch likeDefaultNetherVegetation(int xzSpread, int ySpread) {
            this.xzSpread = xzSpread;
            this.ySpread = ySpread;
            this.tries = xzSpread * xzSpread;
            return this;
        }

        public RandomPatch tries(int v) {
            this.tries = v;
            return this;
        }

        public RandomPatch spreadXZ(int v) {
            this.xzSpread = v;
            return this;
        }

        public RandomPatch spreadY(int v) {
            this.ySpread = v;
            return this;
        }

        @Override
        public RandomPatchConfiguration createConfiguration() {
            return new RandomPatchConfiguration(this.tries, this.xzSpread, this.ySpread, this.featureToPlace);
        }
    }

    public static class AsRandomSelect
    extends BCLFeatureBuilder<RandomSelectorFeature, RandomFeatureConfiguration> {
        private final List<WeightedPlacedFeature> features = new LinkedList<WeightedPlacedFeature>();
        private Holder<PlacedFeature> defaultFeature;

        private AsRandomSelect(@NotNull ResourceLocation featureID, @NotNull RandomSelectorFeature feature) {
            super(featureID, feature);
        }

        public AsRandomSelect add(Holder<PlacedFeature> feature, float weight) {
            this.features.add(new WeightedPlacedFeature(feature, weight));
            return this;
        }

        public AsRandomSelect defaultFeature(Holder<PlacedFeature> feature) {
            this.defaultFeature = feature;
            return this;
        }

        @Override
        public RandomFeatureConfiguration createConfiguration() {
            return new RandomFeatureConfiguration(this.features, this.defaultFeature);
        }
    }

    public static class AsMultiPlaceRandomSelect
    extends BCLFeatureBuilder<RandomSelectorFeature, RandomFeatureConfiguration> {
        private final List<Triple<BlockStateProvider, Float, Integer>> features = new LinkedList<Triple<BlockStateProvider, Float, Integer>>();
        private final Placer modFunction;
        private static int featureCounter = 0;
        private static int lastID = 0;

        private AsMultiPlaceRandomSelect(@NotNull ResourceLocation featureID, @NotNull RandomSelectorFeature feature, @NotNull Placer mod) {
            super(featureID, feature);
            this.modFunction = mod;
        }

        public AsMultiPlaceRandomSelect addAllStates(Block block, int weight) {
            return this.addAllStates(block, weight, lastID + 1);
        }

        public AsMultiPlaceRandomSelect addAll(int weight, Block ... blocks) {
            return this.addAll(weight, lastID + 1, blocks);
        }

        public AsMultiPlaceRandomSelect addAllStatesFor(IntegerProperty prop, Block block, int weight) {
            return this.addAllStatesFor(prop, block, weight, lastID + 1);
        }

        public AsMultiPlaceRandomSelect add(Block block, float weight) {
            return this.add((BlockStateProvider)BlockStateProvider.m_191382_((Block)block), weight);
        }

        public AsMultiPlaceRandomSelect add(BlockState state, float weight) {
            return this.add((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state), weight);
        }

        public AsMultiPlaceRandomSelect add(BlockStateProvider provider, float weight) {
            return this.add(provider, weight, lastID + 1);
        }

        public AsMultiPlaceRandomSelect addAllStates(Block block, int weight, int id) {
            Set<BlockState> states = BCLPoiType.getBlockStates(block);
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
            states.forEach(s -> builder.m_146271_((Object)block.m_49966_(), 1));
            this.add((BlockStateProvider)new WeightedStateProvider(builder.m_146270_()), (float)weight, id);
            return this;
        }

        public AsMultiPlaceRandomSelect addAll(int weight, int id, Block ... blocks) {
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
            for (Block block : blocks) {
                builder.m_146271_((Object)block.m_49966_(), 1);
            }
            this.add((BlockStateProvider)new WeightedStateProvider(builder.m_146270_()), (float)weight, id);
            return this;
        }

        public AsMultiPlaceRandomSelect addAllStatesFor(IntegerProperty prop, Block block, int weight, int id) {
            Collection values = prop.m_6908_();
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
            values.forEach(s -> builder.m_146271_((Object)((BlockState)block.m_49966_().m_61124_((Property)prop, (Comparable)s)), 1));
            this.add((BlockStateProvider)new WeightedStateProvider(builder.m_146270_()), (float)weight, id);
            return this;
        }

        public AsMultiPlaceRandomSelect add(Block block, float weight, int id) {
            return this.add((BlockStateProvider)BlockStateProvider.m_191382_((Block)block), weight, id);
        }

        public AsMultiPlaceRandomSelect add(BlockState state, float weight, int id) {
            return this.add((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state), weight, id);
        }

        public AsMultiPlaceRandomSelect add(BlockStateProvider provider, float weight, int id) {
            this.features.add(new Triple<BlockStateProvider, Float, Integer>(provider, Float.valueOf(weight), id));
            lastID = Math.max(lastID, id);
            return this;
        }

        private Holder<PlacedFeature> place(BlockStateProvider p, int id) {
            BCLInlinePlacedBuilder<SimpleBlockFeature, SimpleBlockConfiguration> builder = BCLFeatureBuilder.start(BCLib.makeID("temp_select_feature" + featureCounter++), p).inlinePlace();
            return this.modFunction.place(builder, id);
        }

        @Override
        public RandomFeatureConfiguration createConfiguration() {
            if (this.modFunction == null) {
                throw new IllegalStateException("AsMultiPlaceRandomSelect needs a placement.modification Function");
            }
            float sum = this.features.stream().map(p -> (Float)p.second).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
            List<WeightedPlacedFeature> features = this.features.stream().map(p -> new WeightedPlacedFeature(this.place((BlockStateProvider)p.first, (Integer)p.third), ((Float)p.second).floatValue() / sum)).toList();
            return new RandomFeatureConfiguration(features.subList(0, features.size() - 1), features.get((int)(features.size() - 1)).f_191172_);
        }

        public static interface Placer {
            public Holder<PlacedFeature> place(BCLInlinePlacedBuilder<SimpleBlockFeature, SimpleBlockConfiguration> var1, int var2);
        }
    }

    public static class NetherForrestVegetation
    extends BCLFeatureBuilder<NetherForestVegetationFeature, NetherForestVegetationConfig> {
        private SimpleWeightedRandomList.Builder<BlockState> blocks;
        private WeightedStateProvider stateProvider;
        private int spreadWidth = 8;
        private int spreadHeight = 4;

        private NetherForrestVegetation(@NotNull ResourceLocation featureID, @NotNull NetherForestVegetationFeature feature) {
            super(featureID, feature);
        }

        public NetherForrestVegetation spreadWidth(int v) {
            this.spreadWidth = v;
            return this;
        }

        public NetherForrestVegetation spreadHeight(int v) {
            this.spreadHeight = v;
            return this;
        }

        public NetherForrestVegetation addAllStates(Block block, int weight) {
            Set<BlockState> states = BCLPoiType.getBlockStates(block);
            states.forEach(s -> this.add(block.m_49966_(), Math.max(1, weight / states.size())));
            return this;
        }

        public NetherForrestVegetation addAllStatesFor(IntegerProperty prop, Block block, int weight) {
            Collection values = prop.m_6908_();
            values.forEach(s -> this.add((BlockState)block.m_49966_().m_61124_((Property)prop, (Comparable)s), Math.max(1, weight / values.size())));
            return this;
        }

        public NetherForrestVegetation add(Block block, int weight) {
            return this.add(block.m_49966_(), weight);
        }

        public NetherForrestVegetation add(BlockState state, int weight) {
            if (this.stateProvider != null) {
                throw new IllegalStateException("You can not add new state once a WeightedStateProvider was built. (" + state + ", " + weight + ")");
            }
            if (this.blocks == null) {
                this.blocks = SimpleWeightedRandomList.m_146263_();
            }
            this.blocks.m_146271_((Object)state, weight);
            return this;
        }

        public NetherForrestVegetation provider(WeightedStateProvider provider) {
            if (this.blocks != null) {
                throw new IllegalStateException("You can not set a WeightedStateProvider after states were added manually.");
            }
            this.stateProvider = provider;
            return this;
        }

        @Override
        public NetherForestVegetationConfig createConfiguration() {
            if (this.stateProvider == null && this.blocks == null) {
                throw new IllegalStateException("NetherForestVegetationConfig needs at least one BlockState");
            }
            if (this.stateProvider == null) {
                this.stateProvider = new WeightedStateProvider(this.blocks.m_146270_());
            }
            return new NetherForestVegetationConfig((BlockStateProvider)this.stateProvider, this.spreadWidth, this.spreadHeight);
        }
    }

    public static class WithTemplates
    extends BCLFeatureBuilder<TemplateFeature<TemplateFeatureConfig>, TemplateFeatureConfig> {
        private final List<StructureWorldNBT> templates = new LinkedList<StructureWorldNBT>();

        private WithTemplates(@NotNull ResourceLocation featureID, @NotNull TemplateFeature<TemplateFeatureConfig> feature) {
            super(featureID, feature);
        }

        public WithTemplates add(ResourceLocation location, int offsetY, StructurePlacementType type, float chance) {
            this.templates.add(TemplateFeatureConfig.cfg(location, offsetY, type, chance));
            return this;
        }

        @Override
        public TemplateFeatureConfig createConfiguration() {
            return new TemplateFeatureConfig(this.templates);
        }
    }

    public static class AsBlockColumn<FF extends Feature<BlockColumnConfiguration>>
    extends BCLFeatureBuilder<FF, BlockColumnConfiguration> {
        private final List<BlockColumnConfiguration.Layer> layers = new LinkedList<BlockColumnConfiguration.Layer>();
        private Direction direction = Direction.UP;
        private BlockPredicate allowedPlacement = BlockPredicate.f_190393_;
        private boolean prioritizeTip = false;

        private AsBlockColumn(@NotNull ResourceLocation featureID, @NotNull FF feature) {
            super(featureID, feature);
        }

        public AsBlockColumn<FF> add(int height, Block block) {
            return this.add((IntProvider)ConstantInt.m_146483_((int)height), (BlockStateProvider)BlockStateProvider.m_191382_((Block)block));
        }

        public AsBlockColumn<FF> add(int height, BlockState state) {
            return this.add((IntProvider)ConstantInt.m_146483_((int)height), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state));
        }

        public AsBlockColumn<FF> add(int height, BlockStateProvider state) {
            return this.add((IntProvider)ConstantInt.m_146483_((int)height), state);
        }

        protected static SimpleWeightedRandomList<BlockState> buildWeightedList(BlockState state) {
            return SimpleWeightedRandomList.m_146263_().m_146271_((Object)state, 1).m_146270_();
        }

        public final AsBlockColumn<FF> addRandom(int height, BlockState ... states) {
            return this.addRandom((IntProvider)ConstantInt.m_146483_((int)height), states);
        }

        public final AsBlockColumn<FF> addRandom(IntProvider height, BlockState ... states) {
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
            for (BlockState state : states) {
                builder.m_146271_((Object)state, 1);
            }
            return this.add(height, (BlockStateProvider)new WeightedStateProvider(builder.m_146270_()));
        }

        public AsBlockColumn<FF> add(IntProvider height, Block block) {
            return this.add(height, (BlockStateProvider)BlockStateProvider.m_191382_((Block)block));
        }

        public AsBlockColumn<FF> add(IntProvider height, BlockState state) {
            return this.add(height, (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state));
        }

        public AsBlockColumn<FF> add(IntProvider height, BlockStateProvider state) {
            this.layers.add(new BlockColumnConfiguration.Layer(height, state));
            return this;
        }

        public AsBlockColumn<FF> addTripleShape(BlockState state, IntProvider midHeight) {
            return this.add(1, (BlockState)state.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM))).add(midHeight, (BlockState)state.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE))).add(1, (BlockState)state.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
        }

        public AsBlockColumn<FF> addTripleShapeUpsideDown(BlockState state, IntProvider midHeight) {
            return this.add(1, (BlockState)state.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP))).add(midHeight, (BlockState)state.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE))).add(1, (BlockState)state.m_61124_(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
        }

        public AsBlockColumn<FF> addBottomShapeUpsideDown(BlockState state, IntProvider midHeight) {
            return this.add(midHeight, (BlockState)state.m_61124_((Property)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(false))).add(1, (BlockState)state.m_61124_((Property)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(true)));
        }

        public AsBlockColumn<FF> addBottomShape(BlockState state, IntProvider midHeight) {
            return this.add(1, (BlockState)state.m_61124_((Property)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(true))).add(midHeight, (BlockState)state.m_61124_((Property)BlockProperties.BOTTOM, (Comparable)Boolean.valueOf(false)));
        }

        public AsBlockColumn<FF> addTopShapeUpsideDown(BlockState state, IntProvider midHeight) {
            return this.add(1, (BlockState)state.m_61124_((Property)BlockProperties.TOP, (Comparable)Boolean.valueOf(true))).add(midHeight, (BlockState)state.m_61124_((Property)BlockProperties.TOP, (Comparable)Boolean.valueOf(false)));
        }

        public AsBlockColumn<FF> addTopShape(BlockState state, IntProvider midHeight) {
            return this.add(midHeight, (BlockState)state.m_61124_((Property)BlockProperties.TOP, (Comparable)Boolean.valueOf(false))).add(1, (BlockState)state.m_61124_((Property)BlockProperties.TOP, (Comparable)Boolean.valueOf(true)));
        }

        public AsBlockColumn<FF> direction(Direction dir) {
            this.direction = dir;
            return this;
        }

        public AsBlockColumn<FF> prioritizeTip() {
            return this.prioritizeTip(true);
        }

        public AsBlockColumn<FF> prioritizeTip(boolean v) {
            this.prioritizeTip = v;
            return this;
        }

        public AsBlockColumn<FF> allowedPlacement(BlockPredicate v) {
            this.allowedPlacement = v;
            return this;
        }

        @Override
        public BlockColumnConfiguration createConfiguration() {
            return new BlockColumnConfiguration(this.layers, this.direction, this.allowedPlacement, this.prioritizeTip);
        }
    }

    public static class AsPillar
    extends BCLFeatureBuilder<PillarFeature, PillarFeatureConfig> {
        private IntProvider maxHeight;
        private IntProvider minHeight;
        private BlockStateProvider stateProvider;
        private final PillarFeatureConfig.KnownTransformers transformer;
        private Direction direction = Direction.UP;
        private BlockPredicate allowedPlacement = BlockPredicate.f_190393_;

        private AsPillar(@NotNull ResourceLocation featureID, @NotNull PillarFeature feature, @NotNull PillarFeatureConfig.KnownTransformers transformer) {
            super(featureID, feature);
            this.transformer = transformer;
        }

        public AsPillar allowedPlacement(BlockPredicate predicate) {
            this.allowedPlacement = predicate;
            return this;
        }

        public AsPillar direction(Direction v) {
            this.direction = v;
            return this;
        }

        public AsPillar blockState(Block v) {
            return this.blockState((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)v.m_49966_()));
        }

        public AsPillar blockState(BlockState v) {
            return this.blockState((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)v));
        }

        public AsPillar blockState(BlockStateProvider v) {
            this.stateProvider = v;
            return this;
        }

        public AsPillar maxHeight(int v) {
            this.maxHeight = ConstantInt.m_146483_((int)v);
            return this;
        }

        public AsPillar maxHeight(IntProvider v) {
            this.maxHeight = v;
            return this;
        }

        public AsPillar minHeight(int v) {
            this.minHeight = ConstantInt.m_146483_((int)v);
            return this;
        }

        public AsPillar minHeight(IntProvider v) {
            this.minHeight = v;
            return this;
        }

        @Override
        public PillarFeatureConfig createConfiguration() {
            if (this.stateProvider == null) {
                throw new IllegalStateException("A Pillar Features need a stateProvider");
            }
            if (this.maxHeight == null) {
                throw new IllegalStateException("A Pillar Features need a height");
            }
            if (this.minHeight == null) {
                this.minHeight = ConstantInt.m_146483_((int)0);
            }
            return new PillarFeatureConfig(this.minHeight, this.maxHeight, this.direction, this.allowedPlacement, this.stateProvider, this.transformer);
        }
    }

    public static class AsSequence
    extends BCLFeatureBuilder<SequenceFeature, SequenceFeatureConfig> {
        private final List<Holder<PlacedFeature>> features = new LinkedList<Holder<PlacedFeature>>();

        private AsSequence(@NotNull ResourceLocation featureID, @NotNull SequenceFeature feature) {
            super(featureID, feature);
        }

        public AsSequence add(BCLFeature<?, ?> p) {
            return this.add(p.placedFeature);
        }

        public AsSequence add(Holder<PlacedFeature> p) {
            this.features.add(p);
            return this;
        }

        @Override
        public SequenceFeatureConfig createConfiguration() {
            return new SequenceFeatureConfig(this.features);
        }
    }

    public static class AsOre
    extends BCLFeatureBuilder<OreFeature, OreConfiguration> {
        private final List<OreConfiguration.TargetBlockState> targetStates = new LinkedList<OreConfiguration.TargetBlockState>();
        private int size = 6;
        private float discardChanceOnAirExposure = 0.0f;

        private AsOre(ResourceLocation featureID, OreFeature feature) {
            super(featureID, feature);
        }

        public AsOre add(Block containedIn, Block ore) {
            return this.add(containedIn, ore.m_49966_());
        }

        public AsOre add(Block containedIn, BlockState ore) {
            return this.add((RuleTest)new BlockMatchTest(containedIn), ore);
        }

        public AsOre add(RuleTest containedIn, Block ore) {
            return this.add(containedIn, ore.m_49966_());
        }

        public AsOre add(RuleTest containedIn, BlockState ore) {
            this.targetStates.add(OreConfiguration.m_161021_((RuleTest)containedIn, (BlockState)ore));
            return this;
        }

        public AsOre veinSize(int size) {
            this.size = size;
            return this;
        }

        public AsOre discardChanceOnAirExposure(float chance) {
            this.discardChanceOnAirExposure = chance;
            return this;
        }

        @Override
        public OreConfiguration createConfiguration() {
            return new OreConfiguration(this.targetStates, this.size, this.discardChanceOnAirExposure);
        }
    }

    public static class FacingBlock
    extends BCLFeatureBuilder<PlaceBlockFeature<PlaceFacingBlockConfig>, PlaceFacingBlockConfig> {
        private final SimpleWeightedRandomList.Builder<BlockState> stateBuilder = SimpleWeightedRandomList.m_146263_();
        BlockState firstState;
        private int count = 0;
        private List<Direction> directions = PlaceFacingBlockConfig.HORIZONTAL;

        private FacingBlock(@NotNull ResourceLocation featureID, @NotNull PlaceBlockFeature<PlaceFacingBlockConfig> feature) {
            super(featureID, feature);
        }

        public FacingBlock allHorizontal() {
            this.directions = PlaceFacingBlockConfig.HORIZONTAL;
            return this;
        }

        public FacingBlock allVertical() {
            this.directions = PlaceFacingBlockConfig.VERTICAL;
            return this;
        }

        public FacingBlock allDirections() {
            this.directions = PlaceFacingBlockConfig.ALL;
            return this;
        }

        public FacingBlock add(Block block) {
            return this.add(block, 1);
        }

        public FacingBlock add(BlockState state) {
            return this.add(state, 1);
        }

        public FacingBlock add(Block block, int weight) {
            return this.add(block.m_49966_(), weight);
        }

        public FacingBlock add(BlockState state, int weight) {
            if (this.firstState == null) {
                this.firstState = state;
            }
            ++this.count;
            this.stateBuilder.m_146271_((Object)state, weight);
            return this;
        }

        public FacingBlock addAllStates(Block block, int weight) {
            Set<BlockState> states = BCLPoiType.getBlockStates(block);
            states.forEach(s -> this.add(block.m_49966_(), Math.max(1, weight / states.size())));
            return this;
        }

        public FacingBlock addAllStatesFor(IntegerProperty prop, Block block, int weight) {
            Collection values = prop.m_6908_();
            values.forEach(s -> this.add((BlockState)block.m_49966_().m_61124_((Property)prop, (Comparable)s), Math.max(1, weight / values.size())));
            return this;
        }

        @Override
        public PlaceFacingBlockConfig createConfiguration() {
            SimpleStateProvider provider = null;
            if (this.count == 1) {
                provider = SimpleStateProvider.m_191384_((BlockState)this.firstState);
            } else {
                SimpleWeightedRandomList list = this.stateBuilder.m_146270_();
                if (!list.m_146337_()) {
                    provider = new WeightedStateProvider(list);
                }
            }
            if (provider == null) {
                throw new IllegalStateException("Facing Blocks need a State Provider.");
            }
            return new PlaceFacingBlockConfig((BlockStateProvider)provider, this.directions);
        }
    }

    @FunctionalInterface
    public static interface FeatureBuilder<F extends Feature<FC>, FC extends FeatureConfiguration, B extends BCLConfigureFeature<F, FC>> {
        public B create(ResourceLocation var1, Holder<ConfiguredFeature<FC, F>> var2);
    }

    @FunctionalInterface
    public static interface HolderBuilder<F extends Feature<FC>, FC extends FeatureConfiguration> {
        public Holder<ConfiguredFeature<FC, F>> apply(ResourceLocation var1, ConfiguredFeature<FC, F> var2);
    }

    private static abstract class WeightedBaseBlock<F extends Feature<FC>, FC extends FeatureConfiguration, W extends WeightedBaseBlock>
    extends BCLFeatureBuilder<F, FC> {
        SimpleWeightedRandomList.Builder<BlockState> stateBuilder = SimpleWeightedRandomList.m_146263_();

        protected WeightedBaseBlock(@NotNull ResourceLocation featureID, @NotNull F feature) {
            super(featureID, feature);
        }

        public W add(Block block, int weight) {
            return this.add(block.m_49966_(), weight);
        }

        public W add(BlockState state, int weight) {
            this.stateBuilder.m_146271_((Object)state, weight);
            return (W)this;
        }

        public W addAllStates(Block block, int weight) {
            Set<BlockState> states = BCLPoiType.getBlockStates(block);
            states.forEach(s -> this.add(block.m_49966_(), Math.max(1, weight / states.size())));
            return (W)this;
        }

        public W addAllStatesFor(IntegerProperty prop, Block block, int weight) {
            Collection values = prop.m_6908_();
            values.forEach(s -> this.add((BlockState)block.m_49966_().m_61124_((Property)prop, (Comparable)s), Math.max(1, weight / values.size())));
            return (W)this;
        }
    }
}

